/*
 * CTreeWidget.h
 *
 *  Created on: 07.05.2009
 *      Author: stefan.detter
 */

#ifndef TREEVIEW_H_
#define TREEVIEW_H_

#include <QTreeView>

class TreeView : public QTreeView
{
	Q_OBJECT
public:
	TreeView( QWidget * parent = 0 );
	virtual ~TreeView();

	void setColumnPercentWidth ( int column, uchar percent );

protected:
	virtual void resizeEvent ( QResizeEvent * event );
	virtual void mousePressEvent ( QMouseEvent * event );

signals:
	void clickedIntoFreeSpace ();

private:
	QByteArray	m_percentWidth;
};

#endif /* TREEVIEW_H_ */


